* International Extension - What Caused the U.S Pandemic-Era Inflation? Bernanke, Blanchard 2023 
* This version : April 16, 2024
* Please contact Dilek Sevinc (dsevinc@piie.com) for further questions. 


* Price regression for 10 economies  (excl. Japan  due to confidentiality issues)
* USA, ECB, BOE, (JPN), FRA, GER, ESP, ITA, NLD, BEL, CAN

global basePath1 ".../Replication Package/(1) Data"
global basePath2 ".../Replication Package/(3) Regression Results"

***************************************************************************************************
* price, precovid samples 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

*** USA, ECB, BOE, JPN, FRA, GER, ITA, ESP, BEL, NLD, CAN // see also seperate do file for GER

local teams "USA ECB BOE FRA GER ESP ITA NLD BEL CAN"
local startperiod_USA 1989:1
local startperiod_ECB 1989:1
local startperiod_BOE 1990:1
local startperiod_FRA 1989:1
local startperiod_GER 1996:1
local startperiod_ITA 1999:1
local startperiod_ESP 1995:1
local startperiod_BEL 1996:1
local startperiod_NLD 1989:1
local startperiod_CAN 1994:1

foreach c of local teams{
	
constraint define 2  l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' + gw_`c' + l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' = 1

cnsreg gcpi_`c' magpty_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c' grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c' shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4)), c(2)

eststo col2
predict gcpif_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4))
gen gcpi_residuals_`c' = gcpi_`c'-gcpif_`c'


* Save coefficients in excel format 
putexcel set "(2) price_eq_coeff", modify sheet("gcpi_`c'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(2) price_summary_stats", modify sheet("gcpi_`c'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.gcpi through l4.gcpi"
putexcel A3 = "gw through l4.gw" 
putexcel A4 = "grpe through l4.grpe"
putexcel A5 = "grpf through l4.grpf"
putexcel A6 = "shortage through l4.shortage"
putexcel A7 = "magpty"
putexcel A9 = "R2"
putexcel A10 = "number of observations"
putexcel A12 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa2_`c' = _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  
gen bb2_`c' = _b[gw_`c'] + _b[l1.gw_`c']   + _b[l2.gw_`c']   + _b[l3.gw_`c']   + _b[l4.gw_`c']
gen cc2_`c' = _b[grpe_`c'] + _b[l1.grpe_`c'] + _b[l2.grpe_`c'] + _b[l3.grpe_`c'] + _b[l4.grpe_`c']  
gen dd2_`c' = _b[grpf_`c'] + _b[l1.grpf_`c'] + _b[l2.grpf_`c'] + _b[l3.grpf_`c'] + _b[l4.grpf_`c']
gen ee2_`c' = _b[shortage_`c'] + _b[l1.shortage_`c'] + _b[l2.shortage_`c'] + _b[l3.shortage_`c'] + _b[l4.shortage_`c']

putexcel B2 = aa2_`c'
putexcel B3 = bb2_`c'
putexcel B4 = cc2_`c'
putexcel B5 = dd2_`c'
putexcel B6 = ee2_`c'
putexcel B7 = _b[magpty_`c']


* P-value (sum)
test _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)

test _b[gw_`c'] + _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c'] = 0 
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7) 

test _b[grpe_`c'] + _b[l1.grpe_`c'] + _b[l2.grpe_`c'] + _b[l3.grpe_`c'] + _b[l4.grpe_`c'] = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)

test _b[grpf_`c'] + _b[l1.grpf_`c'] + _b[l2.grpf_`c'] + _b[l3.grpf_`c'] + _b[l4.grpf_`c'] = 0
matrix b = r(p)'
putexcel C5 = matrix(b), nformat(number_d7)

test _b[shortage_`c'] + _b[l1.shortage_`c'] + _b[l2.shortage_`c'] + _b[l3.shortage_`c'] +_b[l4.shortage_`c'] = 0 
matrix b = r(p)'
putexcel C6 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' 
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  
   
test gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c'
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c'
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    

test grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c'
matrix b = r(p)'
putexcel D5 = matrix(b), nformat(number_d7)    

test shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c'
matrix b = r(p)'
putexcel D6 = matrix(b), nformat(number_d7)

test magpty_`c'
matrix b = r(p)'
putexcel D7 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gcpi_`c' gcpif_`c' if period>=tq(1990:1)
gen r2aa_`c' = r(rho)^2
putexcel B9 = r2aa_`c'

gen n_obsaa_`c' = e(N)
putexcel B10 = n_obsaa_`c'


*** unconstrained with homogeneity test 
reg gcpi_`c' magpty_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c' grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c' shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4))

test _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] + _b[gw_`c'] + _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  = 1
matrix b = r(p)'
putexcel B12 = matrix(b), nformat(number_d7)   

}



***************************************************************************************************
* price, full samples 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


*** USA ECB BOE FRA GER ESP ITA NLD BEL CAN
local teams "USA ECB BOE FRA GER ESP ITA NLD BEL CAN"
local startperiod_USA 1989:1
local startperiod_ECB 1989:1
local startperiod_BOE 1990:1
local startperiod_FRA 1989:1
local startperiod_GER 1996:1
local startperiod_ITA 1999:2
local startperiod_ESP 1995:1
local startperiod_BEL 1996:1
local startperiod_NLD 1989:1
local startperiod_CAN 1994:1

foreach c of local teams{
	
constraint define 2  l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' + gw_`c' + l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' = 1

cnsreg gcpi_`c' magpty_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c' grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c' shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2)), c(2)

eststo col2
predict gcpif_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2))
gen gcpi_residuals_`c' = gcpi_`c'-gcpif_`c'

* Save coefficients in excel format 
putexcel set "(2) price_eq_coeff", modify sheet("gcpi_`c'")
putexcel D1 = "beta_full"
putexcel D1 = "beta_full"
matrix b = e(b)'
putexcel C2 = matrix(b), rownames nformat(number_d7)


* P-value (sum)
putexcel set "(2) price_summary_stats", modify sheet("gcpi_`c'")
putexcel G1 = "sum of coefficients_full"
putexcel G1 = "sum of coefficients_full"
putexcel H1 = "p value (sum)_full"
putexcel I1 = "p value (joint)_full"
putexcel F2 = "l1.gcpi through l4.gcpi"
putexcel F3 = "gw through l4.gw" 
putexcel F4 = "grpe through l4.grpe"
putexcel F5 = "grpf through l4.grpf"
putexcel F6 = "shortage through l4.shortage"
putexcel F7 = "magpty"
putexcel F9 = "R2"
putexcel F10 = "number of observations"
putexcel F12 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa2_`c' = _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  
gen bb2_`c' = _b[gw_`c'] + _b[l1.gw_`c']   + _b[l2.gw_`c']   + _b[l3.gw_`c']   + _b[l4.gw_`c']
gen cc2_`c' = _b[grpe_`c'] + _b[l1.grpe_`c'] + _b[l2.grpe_`c'] + _b[l3.grpe_`c'] + _b[l4.grpe_`c']  
gen dd2_`c' = _b[grpf_`c'] + _b[l1.grpf_`c'] + _b[l2.grpf_`c'] + _b[l3.grpf_`c'] + _b[l4.grpf_`c']
gen ee2_`c' = _b[shortage_`c'] + _b[l1.shortage_`c'] + _b[l2.shortage_`c'] + _b[l3.shortage_`c'] + _b[l4.shortage_`c']

putexcel G2 = aa2_`c'
putexcel G3 = bb2_`c'
putexcel G4 = cc2_`c'
putexcel G5 = dd2_`c'
putexcel G6 = ee2_`c'
putexcel G7 = _b[magpty_`c']


* P-value (sum)
test _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] = 0
matrix b = r(p)'
putexcel H2 = matrix(b), nformat(number_d7)

test _b[gw_`c'] + _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c'] = 0 
matrix b = r(p)'
putexcel H3 = matrix(b), nformat(number_d7) 

test _b[grpe_`c'] + _b[l1.grpe_`c'] + _b[l2.grpe_`c'] + _b[l3.grpe_`c'] + _b[l4.grpe_`c'] = 0
matrix b = r(p)'
putexcel H4 = matrix(b), nformat(number_d7)

test _b[grpf_`c'] + _b[l1.grpf_`c'] + _b[l2.grpf_`c'] + _b[l3.grpf_`c'] + _b[l4.grpf_`c'] = 0
matrix b = r(p)'
putexcel H5 = matrix(b), nformat(number_d7)

test _b[shortage_`c'] + _b[l1.shortage_`c'] + _b[l2.shortage_`c'] + _b[l3.shortage_`c'] +_b[l4.shortage_`c'] = 0 
matrix b = r(p)'
putexcel H6 = matrix(b), nformat(number_d7)

   					   
* P-value(joint)
test l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' 
matrix b = r(p)'
putexcel I2 = matrix(b), nformat(number_d7)  
   
test gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c'
matrix b = r(p)'
putexcel I3 = matrix(b), nformat(number_d7) 
   
test grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c'
matrix b = r(p)'
putexcel I4 = matrix(b), nformat(number_d7)    

test grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c'
matrix b = r(p)'
putexcel I5 = matrix(b), nformat(number_d7)    

test shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c'
matrix b = r(p)'
putexcel I6 = matrix(b), nformat(number_d7)

test magpty_`c'
matrix b = r(p)'
putexcel I7 = matrix(b), nformat(number_d7)


* R-square and number of observations
corr gcpi_`c' gcpif_`c' if period>=tq(1990:1)
gen r2aa_`c' = r(rho)^2
putexcel G9 = r2aa_`c'

gen n_obsaa_`c' = e(N)
putexcel G10 = n_obsaa_`c'


*** unconstrained with homogeneity test 
reg gcpi_`c' magpty_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c' grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c' shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2))

test _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  + _b[gw_`c'] + _b[l1.gw_`c'] + _b[l2.gw_`c'] + _b[l3.gw_`c'] + _b[l4.gw_`c']  = 1
matrix b = r(p)'
putexcel G12 = matrix(b), nformat(number_d7)   


	}
	
